<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* schedule-form-add.twig */
class __TwigTemplate_520db1373cd310826cf0a6a7a2da5a866475beee49a58587d11b34795a7786b5 extends \Twig\Template
{
    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->blocks = [
            'formTitle' => [$this, 'block_formTitle'],
            'callBack' => [$this, 'block_callBack'],
            'formButtons' => [$this, 'block_formButtons'],
            'formHtml' => [$this, 'block_formHtml'],
        ];
    }

    protected function doGetParent(array $context)
    {
        // line 24
        return "form-base.twig";
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        // line 25
        $context["forms"] = $this->loadTemplate("forms.twig", "schedule-form-add.twig", 25)->unwrap();
        // line 24
        $this->parent = $this->loadTemplate("form-base.twig", "schedule-form-add.twig", 24);
        $this->parent->display($context, array_merge($this->blocks, $blocks));
    }

    // line 27
    public function block_formTitle($context, array $blocks = [])
    {
        // line 28
        echo "    ";
        echo __("Schedule Event");
    }

    // line 31
    public function block_callBack($context, array $blocks = [])
    {
        echo "setupScheduleForm";
    }

    // line 33
    public function block_formButtons($context, array $blocks = [])
    {
        // line 34
        echo "    ";
        echo __("Help");
        echo ", XiboHelpRender(\"";
        echo twig_escape_filter($this->env, ($context["help"] ?? null), "html", null, true);
        echo "\")
    ";
        // line 35
        echo __("Cancel");
        echo ", XiboDialogClose()
    ";
        // line 36
        echo __("Next");
        echo ", XiboDialogApply(\"#scheduleAddForm\")
    ";
        // line 37
        echo __("Save");
        echo ", beforeSubmitScheduleForm(\$(\"#scheduleAddForm\"))
";
    }

    // line 40
    public function block_formHtml($context, array $blocks = [])
    {
        // line 41
        echo "    <div class=\"row\">
        <div class=\"col-md-12\">
            <ul class=\"nav nav-tabs\" role=\"tablist\">
                <li class=\"active\"><a href=\"#general\" role=\"tab\" data-toggle=\"tab\"><span>";
        // line 44
        echo __("General");
        echo "</span></a></li>
                <li class=\"repeats\"><a href=\"#repeats\" role=\"tab\" data-toggle=\"tab\"><span>";
        // line 45
        echo __("Repeats");
        echo "</span></a></li>
                <li class=\"reminders\"><a href=\"#reminders\" role=\"tab\" data-toggle=\"tab\"><span>";
        // line 46
        echo __("Reminder");
        echo "</span></a></li>
                <li class=\"geoSchedule\"><a href=\"#geoSchedule\" role=\"tab\" data-toggle=\"tab\"><span>";
        // line 47
        echo __("Geo Location");
        echo "</span></a></li>
            </ul>
            ";
        // line 49
        ob_start();
        echo __("Select the start time for this event");
        $context["dayPartMessage"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 50
        echo "            ";
        ob_start();
        echo __("Start and end time will be defined by the daypart's configuration for this day of the week. Use a repeating schedule to apply this event over multiple days");
        $context["notDayPartMessage"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 51
        echo "            <form id=\"scheduleAddForm\" autocomplete=\"off\" class=\"form-horizontal\" method=\"post\" action=\"";
        echo twig_escape_filter($this->env, $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("schedule.add"), "html", null, true);
        echo "\" data-daypart-message=\"";
        echo twig_escape_filter($this->env, ($context["dayPartMessage"] ?? null), "html", null, true);
        echo "\" data-not-daypart-message=\"";
        echo twig_escape_filter($this->env, ($context["notDayPartMessage"] ?? null), "html", null, true);
        echo "\" data-default-lat=\"";
        echo twig_escape_filter($this->env, ($context["defaultLat"] ?? null), "html", null, true);
        echo "\" data-default-long = \"";
        echo twig_escape_filter($this->env, ($context["defaultLong"] ?? null), "html", null, true);
        echo "\">
                <div class=\"tab-content\">
                    <div class=\"tab-pane active\" id=\"general\">

                        ";
        // line 55
        ob_start();
        echo __("Event Type");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 56
        echo "                        ";
        ob_start();
        echo __("Select the type of event to schedule");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 57
        echo "                        ";
        ob_start();
        echo __("Layout");
        $context["layoutEventType"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 58
        echo "                        ";
        ob_start();
        echo __("Campaign");
        $context["campaignEventType"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 59
        echo "                        ";
        ob_start();
        echo __("Command");
        $context["commandEventType"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 60
        echo "                        ";
        ob_start();
        echo __("Overlay Layout");
        $context["overlayEventType"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 61
        echo "                        ";
        ob_start();
        echo __("Interrupt Layout");
        $context["interruptEventType"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 62
        echo "                        ";
        $context["eventTypes"] = [0 => ["id" => 1, "label" =>         // line 63
($context["layoutEventType"] ?? null)], 1 => ["id" => 5, "label" =>         // line 64
($context["campaignEventType"] ?? null)], 2 => ["id" => 2, "label" =>         // line 65
($context["commandEventType"] ?? null)], 3 => ["id" => 3, "label" =>         // line 66
($context["overlayEventType"] ?? null)], 4 => ["id" => 4, "label" =>         // line 67
($context["interruptEventType"] ?? null)]];
        // line 69
        echo "                        ";
        echo $context["forms"]->getdropdown("eventTypeId", "single", ($context["title"] ?? null), "", ($context["eventTypes"] ?? null), "id", "label", ($context["helpText"] ?? null));
        echo "

                        ";
        // line 71
        ob_start();
        echo __("Display");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 72
        echo "                        ";
        ob_start();
        echo __("Please select one or more displays / groups for this event to be shown on.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 73
        echo "                        ";
        $context["attributes"] = [0 => ["name" => "data-search-url", "value" => $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("schedule.displayGroup.search")], 1 => ["name" => "data-trans-groups", "value" => __("Groups")], 2 => ["name" => "data-trans-display", "value" => __("Display")]];
        // line 78
        echo "                        ";
        echo $context["forms"]->getdropdown("displayGroupIds[]", "dropdownmulti", ($context["title"] ?? null), ($context["displayGroupIds"] ?? null), ($context["displayGroups"] ?? null), "displayGroupId", "displayGroup", ($context["helpText"] ?? null), "", "", "", "", ($context["attributes"] ?? null));
        echo "

                        ";
        // line 80
        ob_start();
        echo __("Dayparting");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 81
        echo "                        ";
        ob_start();
        echo __("Select the dayparting information for this event. To set your own times select custom and to have the event run constantly select Always.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 82
        echo "                        <div class=\"form-group day-part-control\">
                            <label class=\"col-sm-2 control-label\" for=\"dayPartId\">";
        // line 83
        echo twig_escape_filter($this->env, ($context["title"] ?? null), "html", null, true);
        echo "</label>
                            <div class=\"col-sm-10\">
                                <select class=\"form-control\" name=\"dayPartId\" id=\"dayPartId\">
                                    ";
        // line 86
        $context['_parent'] = $context;
        $context['_seq'] = twig_ensure_traversable(($context["dayParts"] ?? null));
        foreach ($context['_seq'] as $context["_key"] => $context["dayPart"]) {
            // line 87
            echo "                                        <option ";
            if (($this->getAttribute($context["dayPart"], "isCustom", []) == 1)) {
                echo "selected";
            }
            // line 88
            echo "                                                value=\"";
            echo twig_escape_filter($this->env, $this->getAttribute($context["dayPart"], "dayPartId", []), "html", null, true);
            echo "\"
                                                data-is-always=\"";
            // line 89
            echo twig_escape_filter($this->env, $this->getAttribute($context["dayPart"], "isAlways", []), "html", null, true);
            echo "\"
                                                data-is-custom=\"";
            // line 90
            echo twig_escape_filter($this->env, $this->getAttribute($context["dayPart"], "isCustom", []), "html", null, true);
            echo "\">";
            echo twig_escape_filter($this->env, $this->getAttribute($context["dayPart"], "name", []), "html", null, true);
            echo "</option>
                                    ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_iterated'], $context['_key'], $context['dayPart'], $context['_parent'], $context['loop']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 92
        echo "                                </select>
                                <span class=\"help-block\">";
        // line 93
        echo twig_escape_filter($this->env, ($context["helpText"] ?? null), "html", null, true);
        echo "</span>
                            </div>
                        </div>

                        ";
        // line 97
        ob_start();
        echo __("Start Time");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 98
        echo "                        ";
        ob_start();
        echo __("Select the start time for this event");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 99
        echo "                        ";
        echo $context["forms"]->getdateTime("fromDt", ($context["title"] ?? null), "", ($context["helpText"] ?? null), "starttime-control", "required");
        echo "

                        ";
        // line 101
        ob_start();
        echo __("End Time");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 102
        echo "                        ";
        ob_start();
        echo __("Select the end time for this event");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 103
        echo "                        ";
        echo $context["forms"]->getdateTime("toDt", ($context["title"] ?? null), "", ($context["helpText"] ?? null), "endtime-control", "required");
        echo "

                        ";
        // line 106
        echo "                        ";
        $context["attributes"] = [0 => ["name" => "data-search-url", "value" => $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("schedule.campaign.search")], 1 => ["name" => "data-search-is-layout-specific", "value" =>  -1], 2 => ["name" => "data-trans-layout", "value" => __("Layout")], 3 => ["name" => "data-trans-layout-help-text", "value" => __("Please select a Layout for this Event to show")], 4 => ["name" => "data-trans-layout", "value" => __("Campaign")], 5 => ["name" => "data-trans-layout-help-text", "value" => __("Please select a Campaign for this Event to show")]];
        // line 114
        echo "
                        ";
        // line 115
        ob_start();
        echo __("Layout");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 116
        echo "                        ";
        ob_start();
        echo __("Please select a Layout for this Event to show");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 117
        echo "                        ";
        echo $context["forms"]->getdropdown("campaignId", "single", ($context["title"] ?? null), "", null, "id", "value", ($context["helpText"] ?? null), "layout-control", "", "", "", ($context["attributes"] ?? null));
        echo "

                        <div class=\"form-group preview-button-container\">
                            <div class=\"col-md-offset-2 col-md-10\">
                                <a id=\"previewButton\" class=\"btn btn-success\" target=\"_blank\" data-url=\"";
        // line 121
        echo twig_escape_filter($this->env, $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("campaign.preview"), "html", null, true);
        echo "\">";
        echo __("Preview");
        echo " <span class=\"fa fa-tablet\"></span></a>
                                <span class=\"help-block\">";
        // line 122
        echo __("Preview your selection in a new tab");
        echo "</span>
                            </div>
                        </div>

                        <div class=\"form-group interrupt-control\" style=\"display: block;\">
                            <label class=\"col-sm-2 control-label\" for=\"shareOfVoice\" accesskey=\"\">";
        // line 127
        echo __("Share of Voice");
        echo "</label>
                            <div class=\"col-sm-5\">
                                <input class=\"form-control\" name=\"shareOfVoice\" type=\"number\" id=\"shareOfVoice\" value=\"0\">
                                <span class=\"help-block\">";
        // line 130
        echo __("The amount of time this Layout should be shown, in seconds per hour.");
        echo "</span>
                            </div>

                            <div class=\"col-sm-5\">
                                <input class=\"form-control\" name=\"shareOfVoicePercentage\" type=\"number\" id=\"shareOfVoicePercentage\" value=\"\">
                                <span class=\"help-block\">";
        // line 135
        echo __("As a percentage");
        echo "</span>
                            </div>
                        </div>

                        ";
        // line 139
        ob_start();
        echo __("Command");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 140
        echo "                        ";
        ob_start();
        echo __("Please select a command for this Event.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 141
        echo "                        ";
        echo $context["forms"]->getdropdown("commandId", "single", ($context["title"] ?? null), "", twig_array_merge([0 => ["commandId" => "", "command" => ""]], ($context["commands"] ?? null)), "commandId", "command", ($context["helpText"] ?? null), "command-control");
        echo "

                        ";
        // line 143
        ob_start();
        echo __("Display Order");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 144
        echo "                        ";
        ob_start();
        echo __("Please select the order this event should appear in relation to others when there is more than one event scheduled");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 145
        echo "                        ";
        echo $context["forms"]->getnumber("displayOrder", ($context["title"] ?? null), "", ($context["helpText"] ?? null), "displayOrder-control");
        echo "

                        ";
        // line 147
        ob_start();
        echo __("Priority");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 148
        echo "                        ";
        ob_start();
        echo __("Sets the event priority - events with the highest priority play in preference to lower priority events.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 149
        echo "                        ";
        echo $context["forms"]->getnumber("isPriority", ($context["title"] ?? null), "", ($context["helpText"] ?? null), "priority-control");
        echo "

                        ";
        // line 151
        ob_start();
        echo __("Run at CMS Time?");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 152
        echo "                        ";
        ob_start();
        echo __("When selected, your event will run according to the timezone set on the CMS, otherwise the event will run at Display local time");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 153
        echo "                        ";
        echo $context["forms"]->getcheckbox("syncTimezone", ($context["title"] ?? null), 0, ($context["helpText"] ?? null));
        echo "

                        ";
        // line 155
        if (($this->getAttribute(($context["settings"] ?? null), "EVENT_SYNC", []) == 1)) {
            // line 156
            echo "                            ";
            ob_start();
            echo __("Synchronise this event?");
            $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
            // line 157
            echo "                            ";
            ob_start();
            echo __("When selected, all selected players will attempt to synchronise the output (Supported on Android player only)");
            $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
            // line 158
            echo "                            ";
            echo $context["forms"]->getcheckbox("syncEvent", ($context["title"] ?? null), 0, ($context["helpText"] ?? null), "sync-schedule-control");
            echo "
                        ";
        }
        // line 160
        echo "
                    </div>
                    
                    <div class=\"tab-pane\" id=\"repeats\">
                        ";
        // line 164
        ob_start();
        echo __("Repeats");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 165
        echo "                        ";
        ob_start();
        echo __("Select the type of Repeat required for this Event.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 166
        echo "                        ";
        ob_start();
        echo __("None");
        $context["noneOption"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 167
        echo "                        ";
        ob_start();
        echo __("Per Minute");
        $context["minute"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 168
        echo "                        ";
        ob_start();
        echo __("Hourly");
        $context["hourly"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 169
        echo "                        ";
        ob_start();
        echo __("Daily");
        $context["daily"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 170
        echo "                        ";
        ob_start();
        echo __("Weekly");
        $context["weekly"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 171
        echo "                        ";
        ob_start();
        echo __("Monthly");
        $context["monthly"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 172
        echo "                        ";
        ob_start();
        echo __("Yearly");
        $context["yearly"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 173
        echo "                        ";
        $context["options"] = [0 => ["id" => "", "name" =>         // line 174
($context["noneOption"] ?? null)], 1 => ["id" => "Minute", "name" =>         // line 175
($context["minute"] ?? null)], 2 => ["id" => "Hour", "name" =>         // line 176
($context["hourly"] ?? null)], 3 => ["id" => "Day", "name" =>         // line 177
($context["daily"] ?? null)], 4 => ["id" => "Week", "name" =>         // line 178
($context["weekly"] ?? null)], 5 => ["id" => "Month", "name" =>         // line 179
($context["monthly"] ?? null)], 6 => ["id" => "Year", "name" =>         // line 180
($context["yearly"] ?? null)]];
        // line 182
        echo "                        ";
        echo $context["forms"]->getdropdown("recurrenceType", "single", ($context["title"] ?? null), "", ($context["options"] ?? null), "id", "name", ($context["helpText"] ?? null));
        echo "

                        ";
        // line 184
        ob_start();
        echo __("Use the drop-down to select which days of the week this Event should be repeated.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 185
        echo "                        ";
        ob_start();
        echo __("Monday");
        $context["monday"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 186
        echo "                        ";
        ob_start();
        echo __("Tuesday");
        $context["tuesday"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 187
        echo "                        ";
        ob_start();
        echo __("Wednesday");
        $context["wednesday"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 188
        echo "                        ";
        ob_start();
        echo __("Thursday");
        $context["thursday"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 189
        echo "                        ";
        ob_start();
        echo __("Friday");
        $context["friday"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 190
        echo "                        ";
        ob_start();
        echo __("Saturday");
        $context["saturday"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 191
        echo "                        ";
        ob_start();
        echo __("Sunday");
        $context["sunday"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 192
        echo "                        ";
        $context["options"] = [0 => ["id" => 1, "name" =>         // line 193
($context["monday"] ?? null)], 1 => ["id" => 2, "name" =>         // line 194
($context["tuesday"] ?? null)], 2 => ["id" => 3, "name" =>         // line 195
($context["wednesday"] ?? null)], 3 => ["id" => 4, "name" =>         // line 196
($context["thursday"] ?? null)], 4 => ["id" => 5, "name" =>         // line 197
($context["friday"] ?? null)], 5 => ["id" => 6, "name" =>         // line 198
($context["saturday"] ?? null)], 6 => ["id" => 7, "name" =>         // line 199
($context["sunday"] ?? null)]];
        // line 201
        echo "                        ";
        echo $context["forms"]->getdropdown("recurrenceRepeatsOn[]", "dropdownmulti", "", $this->getAttribute(($context["event"] ?? null), "recurrenceRepeatsOn", []), ($context["options"] ?? null), "id", "name", ($context["helpText"] ?? null), "repeat-weekly-control-group");
        echo "

                        ";
        // line 203
        ob_start();
        echo __("Should this Event Repeat by Day of the month (eg. Monthly on Day 21) or by a Weekday in the month (eg. Monthly on the third Thursday).");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 204
        echo "                        ";
        $context["attributes"] = [0 => ["name" => "data-trans-day", "value" => __("on the [DAY] day")], 1 => ["name" => "data-trans-weekday", "value" => __("on the [POSITION] [WEEKDAY]")]];
        // line 208
        echo "                        ";
        echo $context["forms"]->getdropdown("recurrenceMonthlyRepeatsOn", "single", "", 0, [], "id", "name", ($context["helpText"] ?? null), "repeat-monthly-control-group", "", "", "", ($context["attributes"] ?? null));
        echo "

                        ";
        // line 210
        ob_start();
        echo __("Repeat every");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 211
        echo "                        ";
        ob_start();
        echo __("Include a number to determine the Repeat frequency required for this Event.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 212
        echo "                        ";
        echo $context["forms"]->getnumber("recurrenceDetail", ($context["title"] ?? null), ($context["recurrenceDetail"] ?? null), ($context["helpText"] ?? null), "repeat-control-group");
        echo "

                        ";
        // line 214
        ob_start();
        echo __("Until");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 215
        echo "                        ";
        ob_start();
        echo __("Provide a date and time to end the Repeat for this Event. Leave empty to Repeat indefinitely.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 216
        echo "                        ";
        echo $context["forms"]->getdateTime("recurrenceRange", ($context["title"] ?? null), "", ($context["helpText"] ?? null), "repeat-control-group", "", "");
        echo "
                    </div>

                    <div class=\"tab-pane\" id=\"reminders\">
                        ";
        // line 220
        ob_start();
        echo __("Use the form fields below to create a set of reminders for this event. New fields can be added by clicking on the + icon at the end of the row. Use the tick box to receive a notification by email alternatively reminders will be shown in the message center.");
        $context["message"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 221
        echo "                        ";
        echo $context["forms"]->getmessage(($context["message"] ?? null));
        echo "
                        <div id=\"reminderFields\" data-reminders=\"";
        // line 222
        echo twig_escape_filter($this->env, twig_jsonencode_filter(($context["reminders"] ?? null)), "html", null, true);
        echo "\"></div>
                    </div>

                    <div class=\"tab-pane\" id=\"geoSchedule\">
                        ";
        // line 226
        ob_start();
        echo __("Geo Schedule?");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 227
        echo "                        ";
        ob_start();
        echo __("Should this event be location aware? Enable this checkbox and select an area by drawing a polygon or rectangle layer on the map below.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 228
        echo "                        ";
        echo $context["forms"]->getcheckbox("isGeoAware", ($context["title"] ?? null), 0, ($context["helpText"] ?? null), "");
        echo "

                        <div id=\"geoScheduleMap\" style=\"height: 500px; width: 100%\" class=\"hidden\"></div>

                        ";
        // line 232
        echo $context["forms"]->gethidden("geoLocation", "");
        echo "
                    </div>
                </div>
            </form>
        </div>
    </div>
";
    }

    public function getTemplateName()
    {
        return "schedule-form-add.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  620 => 232,  612 => 228,  607 => 227,  603 => 226,  596 => 222,  591 => 221,  587 => 220,  579 => 216,  574 => 215,  570 => 214,  564 => 212,  559 => 211,  555 => 210,  549 => 208,  546 => 204,  542 => 203,  536 => 201,  534 => 199,  533 => 198,  532 => 197,  531 => 196,  530 => 195,  529 => 194,  528 => 193,  526 => 192,  521 => 191,  516 => 190,  511 => 189,  506 => 188,  501 => 187,  496 => 186,  491 => 185,  487 => 184,  481 => 182,  479 => 180,  478 => 179,  477 => 178,  476 => 177,  475 => 176,  474 => 175,  473 => 174,  471 => 173,  466 => 172,  461 => 171,  456 => 170,  451 => 169,  446 => 168,  441 => 167,  436 => 166,  431 => 165,  427 => 164,  421 => 160,  415 => 158,  410 => 157,  405 => 156,  403 => 155,  397 => 153,  392 => 152,  388 => 151,  382 => 149,  377 => 148,  373 => 147,  367 => 145,  362 => 144,  358 => 143,  352 => 141,  347 => 140,  343 => 139,  336 => 135,  328 => 130,  322 => 127,  314 => 122,  308 => 121,  300 => 117,  295 => 116,  291 => 115,  288 => 114,  285 => 106,  279 => 103,  274 => 102,  270 => 101,  264 => 99,  259 => 98,  255 => 97,  248 => 93,  245 => 92,  235 => 90,  231 => 89,  226 => 88,  221 => 87,  217 => 86,  211 => 83,  208 => 82,  203 => 81,  199 => 80,  193 => 78,  190 => 73,  185 => 72,  181 => 71,  175 => 69,  173 => 67,  172 => 66,  171 => 65,  170 => 64,  169 => 63,  167 => 62,  162 => 61,  157 => 60,  152 => 59,  147 => 58,  142 => 57,  137 => 56,  133 => 55,  117 => 51,  112 => 50,  108 => 49,  103 => 47,  99 => 46,  95 => 45,  91 => 44,  86 => 41,  83 => 40,  77 => 37,  73 => 36,  69 => 35,  62 => 34,  59 => 33,  53 => 31,  48 => 28,  45 => 27,  40 => 24,  38 => 25,  32 => 24,);
    }

    /** @deprecated since 1.27 (to be removed in 2.0). Use getSourceContext() instead */
    public function getSource()
    {
        @trigger_error('The '.__METHOD__.' method is deprecated since version 1.27 and will be removed in 2.0. Use getSourceContext() instead.', E_USER_DEPRECATED);

        return $this->getSourceContext()->getCode();
    }

    public function getSourceContext()
    {
        return new Source("{#
/*
 * Copyright (C) 2019 Xibo Signage Ltd
 *
 * Xibo - Digital Signage - http://www.xibo.org.uk
 *
 * This file is part of Xibo.
 *
 * Xibo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * Xibo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Xibo.  If not, see <http://www.gnu.org/licenses/>.
 */
#}

{% extends \"form-base.twig\" %}
{% import \"forms.twig\" as forms %}

{% block formTitle %}
    {% trans \"Schedule Event\" %}
{% endblock %}

{% block callBack %}setupScheduleForm{% endblock %}

{% block formButtons %}
    {% trans \"Help\" %}, XiboHelpRender(\"{{ help }}\")
    {% trans \"Cancel\" %}, XiboDialogClose()
    {% trans \"Next\" %}, XiboDialogApply(\"#scheduleAddForm\")
    {% trans \"Save\" %}, beforeSubmitScheduleForm(\$(\"#scheduleAddForm\"))
{% endblock %}

{% block formHtml %}
    <div class=\"row\">
        <div class=\"col-md-12\">
            <ul class=\"nav nav-tabs\" role=\"tablist\">
                <li class=\"active\"><a href=\"#general\" role=\"tab\" data-toggle=\"tab\"><span>{% trans \"General\" %}</span></a></li>
                <li class=\"repeats\"><a href=\"#repeats\" role=\"tab\" data-toggle=\"tab\"><span>{% trans \"Repeats\" %}</span></a></li>
                <li class=\"reminders\"><a href=\"#reminders\" role=\"tab\" data-toggle=\"tab\"><span>{% trans \"Reminder\" %}</span></a></li>
                <li class=\"geoSchedule\"><a href=\"#geoSchedule\" role=\"tab\" data-toggle=\"tab\"><span>{% trans \"Geo Location\" %}</span></a></li>
            </ul>
            {% set dayPartMessage %}{% trans \"Select the start time for this event\" %}{% endset %}
            {% set notDayPartMessage %}{% trans \"Start and end time will be defined by the daypart's configuration for this day of the week. Use a repeating schedule to apply this event over multiple days\" %}{% endset %}
            <form id=\"scheduleAddForm\" autocomplete=\"off\" class=\"form-horizontal\" method=\"post\" action=\"{{ urlFor(\"schedule.add\") }}\" data-daypart-message=\"{{ dayPartMessage }}\" data-not-daypart-message=\"{{ notDayPartMessage }}\" data-default-lat=\"{{ defaultLat }}\" data-default-long = \"{{ defaultLong }}\">
                <div class=\"tab-content\">
                    <div class=\"tab-pane active\" id=\"general\">

                        {% set title %}{% trans \"Event Type\" %}{% endset %}
                        {% set helpText %}{% trans \"Select the type of event to schedule\" %}{% endset %}
                        {% set layoutEventType %}{% trans \"Layout\" %}{% endset %}
                        {% set campaignEventType %}{% trans \"Campaign\" %}{% endset %}
                        {% set commandEventType %}{% trans \"Command\" %}{% endset %}
                        {% set overlayEventType %}{% trans \"Overlay Layout\" %}{% endset %}
                        {% set interruptEventType %}{% trans \"Interrupt Layout\" %}{% endset %}
                        {% set eventTypes = [
                        {id: 1, label: layoutEventType},
                        {id: 5, label: campaignEventType},
                        {id: 2, label: commandEventType},
                        {id: 3, label: overlayEventType},
                        {id: 4, label: interruptEventType}
                        ] %}
                        {{ forms.dropdown(\"eventTypeId\", \"single\", title, \"\", eventTypes, \"id\", \"label\", helpText) }}

                        {% set title %}{% trans \"Display\" %}{% endset %}
                        {% set helpText %}{% trans \"Please select one or more displays / groups for this event to be shown on.\" %}{% endset %}
                        {% set attributes = [
                            { name: \"data-search-url\", value:  urlFor(\"schedule.displayGroup.search\") },
                            { name: \"data-trans-groups\", value:  \"Groups\"|trans },
                            { name: \"data-trans-display\", value:  \"Display\"|trans }
                        ] %}
                        {{ forms.dropdown(\"displayGroupIds[]\", \"dropdownmulti\", title, displayGroupIds, displayGroups, \"displayGroupId\", \"displayGroup\", helpText, \"\", \"\", \"\", \"\", attributes) }}

                        {% set title %}{% trans \"Dayparting\" %}{% endset %}
                        {% set helpText %}{% trans \"Select the dayparting information for this event. To set your own times select custom and to have the event run constantly select Always.\" %}{% endset %}
                        <div class=\"form-group day-part-control\">
                            <label class=\"col-sm-2 control-label\" for=\"dayPartId\">{{ title }}</label>
                            <div class=\"col-sm-10\">
                                <select class=\"form-control\" name=\"dayPartId\" id=\"dayPartId\">
                                    {% for dayPart in dayParts %}
                                        <option {% if dayPart.isCustom == 1 %}selected{% endif %}
                                                value=\"{{ dayPart.dayPartId }}\"
                                                data-is-always=\"{{ dayPart.isAlways }}\"
                                                data-is-custom=\"{{ dayPart.isCustom }}\">{{ dayPart.name }}</option>
                                    {% endfor %}
                                </select>
                                <span class=\"help-block\">{{ helpText }}</span>
                            </div>
                        </div>

                        {% set title %}{% trans \"Start Time\" %}{% endset %}
                        {% set helpText %}{% trans \"Select the start time for this event\" %}{% endset %}
                        {{ forms.dateTime(\"fromDt\", title, \"\", helpText, \"starttime-control\", \"required\") }}

                        {% set title %}{% trans \"End Time\" %}{% endset %}
                        {% set helpText %}{% trans \"Select the end time for this event\" %}{% endset %}
                        {{ forms.dateTime(\"toDt\", title, \"\", helpText, \"endtime-control\", \"required\") }}

                        {# Campaign / Layout list. We want to build two arrays for us to use. #}
                        {% set attributes = [
                            { name: \"data-search-url\", value:  urlFor(\"schedule.campaign.search\") },
                            { name: \"data-search-is-layout-specific\", value: -1 },
                            { name: \"data-trans-layout\", value: \"Layout\"|trans },
                            { name: \"data-trans-layout-help-text\", value: \"Please select a Layout for this Event to show\"|trans },
                            { name: \"data-trans-layout\", value: \"Campaign\"|trans },
                            { name: \"data-trans-layout-help-text\", value: \"Please select a Campaign for this Event to show\"|trans },
                        ] %}

                        {% set title %}{% trans \"Layout\" %}{% endset %}
                        {% set helpText %}{% trans \"Please select a Layout for this Event to show\" %}{% endset %}
                        {{ forms.dropdown(\"campaignId\", \"single\", title, \"\", null, \"id\", \"value\", helpText, \"layout-control\", \"\", \"\", \"\", attributes) }}

                        <div class=\"form-group preview-button-container\">
                            <div class=\"col-md-offset-2 col-md-10\">
                                <a id=\"previewButton\" class=\"btn btn-success\" target=\"_blank\" data-url=\"{{ urlFor(\"campaign.preview\") }}\">{% trans \"Preview\" %} <span class=\"fa fa-tablet\"></span></a>
                                <span class=\"help-block\">{% trans \"Preview your selection in a new tab\" %}</span>
                            </div>
                        </div>

                        <div class=\"form-group interrupt-control\" style=\"display: block;\">
                            <label class=\"col-sm-2 control-label\" for=\"shareOfVoice\" accesskey=\"\">{% trans \"Share of Voice\" %}</label>
                            <div class=\"col-sm-5\">
                                <input class=\"form-control\" name=\"shareOfVoice\" type=\"number\" id=\"shareOfVoice\" value=\"0\">
                                <span class=\"help-block\">{% trans \"The amount of time this Layout should be shown, in seconds per hour.\" %}</span>
                            </div>

                            <div class=\"col-sm-5\">
                                <input class=\"form-control\" name=\"shareOfVoicePercentage\" type=\"number\" id=\"shareOfVoicePercentage\" value=\"\">
                                <span class=\"help-block\">{% trans \"As a percentage\" %}</span>
                            </div>
                        </div>

                        {% set title %}{% trans \"Command\" %}{% endset %}
                        {% set helpText %}{% trans \"Please select a command for this Event.\" %}{% endset %}
                        {{ forms.dropdown(\"commandId\", \"single\", title, \"\", [{commandId: \"\", command: \"\"}]|merge(commands), \"commandId\", \"command\", helpText, \"command-control\") }}

                        {% set title %}{% trans \"Display Order\" %}{% endset %}
                        {% set helpText %}{% trans \"Please select the order this event should appear in relation to others when there is more than one event scheduled\" %}{% endset %}
                        {{ forms.number(\"displayOrder\", title, \"\", helpText, 'displayOrder-control') }}

                        {% set title %}{% trans \"Priority\" %}{% endset %}
                        {% set helpText %}{% trans \"Sets the event priority - events with the highest priority play in preference to lower priority events.\" %}{% endset %}
                        {{ forms.number(\"isPriority\", title, \"\", helpText, 'priority-control') }}

                        {% set title %}{% trans \"Run at CMS Time?\" %}{% endset %}
                        {% set helpText %}{% trans \"When selected, your event will run according to the timezone set on the CMS, otherwise the event will run at Display local time\" %}{% endset %}
                        {{ forms.checkbox(\"syncTimezone\", title, 0, helpText) }}

                        {% if settings.EVENT_SYNC == 1 %}
                            {% set title %}{% trans \"Synchronise this event?\" %}{% endset %}
                            {% set helpText %}{% trans \"When selected, all selected players will attempt to synchronise the output (Supported on Android player only)\" %}{% endset %}
                            {{ forms.checkbox(\"syncEvent\", title, 0, helpText, \"sync-schedule-control\") }}
                        {% endif %}

                    </div>
                    
                    <div class=\"tab-pane\" id=\"repeats\">
                        {% set title %}{% trans \"Repeats\" %}{% endset %}
                        {% set helpText %}{% trans \"Select the type of Repeat required for this Event.\" %}{% endset %}
                        {% set noneOption %}{% trans \"None\" %}{% endset %}
                        {% set minute %}{% trans \"Per Minute\" %}{% endset %}
                        {% set hourly %}{% trans \"Hourly\" %}{% endset %}
                        {% set daily %}{% trans \"Daily\" %}{% endset %}
                        {% set weekly %}{% trans \"Weekly\" %}{% endset %}
                        {% set monthly %}{% trans \"Monthly\" %}{% endset %}
                        {% set yearly %}{% trans \"Yearly\" %}{% endset %}
                        {% set options = [
                        { id: \"\", name: noneOption },
                        { id: \"Minute\", name: minute },
                        { id: \"Hour\", name: hourly},
                        { id: \"Day\", name: daily},
                        { id: \"Week\", name: weekly},
                        { id: \"Month\", name: monthly},
                        { id: \"Year\", name: yearly}
                        ] %}
                        {{ forms.dropdown(\"recurrenceType\", \"single\", title, \"\", options, \"id\", \"name\", helpText) }}

                        {% set helpText %}{% trans \"Use the drop-down to select which days of the week this Event should be repeated.\" %}{% endset %}
                        {% set monday %}{% trans \"Monday\" %}{% endset %}
                        {% set tuesday %}{% trans \"Tuesday\" %}{% endset %}
                        {% set wednesday %}{% trans \"Wednesday\" %}{% endset %}
                        {% set thursday %}{% trans \"Thursday\" %}{% endset %}
                        {% set friday %}{% trans \"Friday\" %}{% endset %}
                        {% set saturday %}{% trans \"Saturday\" %}{% endset %}
                        {% set sunday %}{% trans \"Sunday\" %}{% endset %}
                        {% set options = [
                        { id: 1, name: monday },
                        { id: 2, name: tuesday },
                        { id: 3, name: wednesday },
                        { id: 4, name: thursday },
                        { id: 5, name: friday },
                        { id: 6, name: saturday },
                        { id: 7, name: sunday },
                        ] %}
                        {{ forms.dropdown(\"recurrenceRepeatsOn[]\", \"dropdownmulti\", \"\", event.recurrenceRepeatsOn, options, \"id\", \"name\", helpText, \"repeat-weekly-control-group\") }}

                        {% set helpText %}{% trans \"Should this Event Repeat by Day of the month (eg. Monthly on Day 21) or by a Weekday in the month (eg. Monthly on the third Thursday).\" %}{% endset %}
                        {% set attributes = [
                            { name: \"data-trans-day\", value: \"on the [DAY] day\"|trans },
                            { name: \"data-trans-weekday\", value: \"on the [POSITION] [WEEKDAY]\"|trans }
                        ] %}
                        {{ forms.dropdown(\"recurrenceMonthlyRepeatsOn\", \"single\", \"\", 0, [], \"id\", \"name\", helpText, \"repeat-monthly-control-group\", \"\", \"\", \"\", attributes) }}

                        {% set title %}{% trans \"Repeat every\" %}{% endset %}
                        {% set helpText %}{% trans \"Include a number to determine the Repeat frequency required for this Event.\" %}{% endset %}
                        {{ forms.number(\"recurrenceDetail\", title, recurrenceDetail, helpText, \"repeat-control-group\") }}

                        {% set title %}{% trans \"Until\" %}{% endset %}
                        {% set helpText %}{% trans \"Provide a date and time to end the Repeat for this Event. Leave empty to Repeat indefinitely.\" %}{% endset %}
                        {{ forms.dateTime(\"recurrenceRange\", title, \"\", helpText, \"repeat-control-group\", \"\", \"\") }}
                    </div>

                    <div class=\"tab-pane\" id=\"reminders\">
                        {% set message %}{% trans \"Use the form fields below to create a set of reminders for this event. New fields can be added by clicking on the + icon at the end of the row. Use the tick box to receive a notification by email alternatively reminders will be shown in the message center.\" %}{% endset %}
                        {{ forms.message(message) }}
                        <div id=\"reminderFields\" data-reminders=\"{{ reminders|json_encode }}\"></div>
                    </div>

                    <div class=\"tab-pane\" id=\"geoSchedule\">
                        {% set title %}{% trans \"Geo Schedule?\" %}{% endset %}
                        {% set helpText %}{% trans \"Should this event be location aware? Enable this checkbox and select an area by drawing a polygon or rectangle layer on the map below.\" %}{% endset %}
                        {{ forms.checkbox(\"isGeoAware\", title, 0, helpText, \"\") }}

                        <div id=\"geoScheduleMap\" style=\"height: 500px; width: 100%\" class=\"hidden\"></div>

                        {{ forms.hidden(\"geoLocation\", \"\") }}
                    </div>
                </div>
            </form>
        </div>
    </div>
{% endblock %}", "schedule-form-add.twig", "/home/dlccorporativo/signage.dlccorporativo.com/xib/views/schedule-form-add.twig");
    }
}
