<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* displaygroup-page.twig */
class __TwigTemplate_44bf7d409a913311865fc6b88e6cf9af5c70f2a3c1eb60d5edc1f1968977e80b extends \Twig\Template
{
    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->blocks = [
            'actionMenu' => [$this, 'block_actionMenu'],
            'pageContent' => [$this, 'block_pageContent'],
            'javaScript' => [$this, 'block_javaScript'],
        ];
    }

    protected function doGetParent(array $context)
    {
        // line 9
        return "authed.twig";
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        // line 10
        $context["inline"] = $this->loadTemplate("inline.twig", "displaygroup-page.twig", 10)->unwrap();
        // line 9
        $this->parent = $this->loadTemplate("authed.twig", "displaygroup-page.twig", 9);
        $this->parent->display($context, array_merge($this->blocks, $blocks));
    }

    // line 12
    public function block_actionMenu($context, array $blocks = [])
    {
        // line 13
        echo "    <ul class=\"nav nav-pills pull-right\">
        <li class=\"btn btn-success btn-xs\"><a class=\"XiboFormButton btns\" title=\"";
        // line 14
        echo __("Add a new Display Group");
        echo "\" href=\"";
        echo twig_escape_filter($this->env, $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("displayGroup.add.form"), "html", null, true);
        echo "\"> <i class=\"fa fa-desktop\" aria-hidden=\"true\"></i> ";
        echo __("Add Display Group");
        echo "</a></li>
    </ul>
";
    }

    // line 18
    public function block_pageContent($context, array $blocks = [])
    {
        // line 19
        echo "    <div class=\"widget\">
        <div class=\"widget-title\">";
        // line 20
        echo __("Display Groups");
        echo "</div>
        <div class=\"widget-body\">
            <div class=\"XiboGrid\" id=\"";
        // line 22
        echo twig_escape_filter($this->env, twig_random($this->env), "html", null, true);
        echo "\">
                <div class=\"XiboFilter well\">
                    <div class=\"FilterDiv\" id=\"Filter\">
                        <form class=\"form-inline\">
                            ";
        // line 26
        ob_start();
        echo __("ID");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 27
        echo "                            ";
        echo $context["inline"]->getinput("displayGroupId", ($context["title"] ?? null));
        echo "

                            <div class=\"form-group \">
                                <label class=\"control-label\" title=\"\" for=\"displayGroup\" accesskey=\"\">";
        // line 30
        echo __("Name");
        echo "</label>
                                <div>
                                    <div class=\"input-group\">
                                        <input class=\"form-control\" name=\"displayGroup\" type=\"text\" id=\"displayGroup\" value=\"\">
                                        <span class=\"input-group-addon\">
                                            <input title=\"";
        // line 35
        echo __("Use Regex?");
        echo "\" type=\"checkbox\" id=\"useRegexForName\" name=\"useRegexForName\">
                                        </span>
                                    </div>
                                </div>
                            </div>

                            ";
        // line 41
        ob_start();
        echo __("Display");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 42
        echo "                            ";
        $context["attributes"] = [0 => ["name" => "data-width", "value" => "200px"], 1 => ["name" => "data-allow-clear", "value" => "true"], 2 => ["name" => "data-placeholder--id", "value" => null], 3 => ["name" => "data-placeholder--value", "value" => ""], 4 => ["name" => "data-search-url", "value" => $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("display.search")], 5 => ["name" => "data-search-term", "value" => "display"], 6 => ["name" => "data-search-term-tags", "value" => "tags"], 7 => ["name" => "data-id-property", "value" => "displayId"], 8 => ["name" => "data-text-property", "value" => "display"]];
        // line 53
        echo "                            ";
        ob_start();
        echo __("Return Display Groups that directly contain the selected Display.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 54
        echo "                            ";
        echo $context["inline"]->getdropdown("displayId", "single", ($context["title"] ?? null), "", null, "displayId", "display", ($context["helpText"] ?? null), "pagedSelect", "", "", "", ($context["attributes"] ?? null));
        echo "

                            ";
        // line 56
        ob_start();
        echo __("Nested Display");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 57
        echo "                            ";
        ob_start();
        echo __("Return Display Groups that contain the selected Display somewhere in the nested Display Group relationship tree.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 58
        echo "                            ";
        echo $context["inline"]->getdropdown("nestedDisplayId", "single", ($context["title"] ?? null), "", null, "displayId", "display", ($context["helpText"] ?? null), "pagedSelect", "", "", "", ($context["attributes"] ?? null));
        echo "

                            ";
        // line 60
        ob_start();
        echo __("Dynamic Criteria");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 61
        echo "                            ";
        echo $context["inline"]->getinput("dynamicCriteria", ($context["title"] ?? null));
        echo "

                            ";
        // line 63
        ob_start();
        echo __("Tags");
        $context["title"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 64
        echo "                            ";
        ob_start();
        echo __("Exact match?");
        $context["exactTagTitle"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 65
        echo "                            ";
        ob_start();
        echo __("A comma separated list of tags to filter by. Enter a Tag value preceded with | to filter by Tag values. Enter --no-tag to see items without tags.");
        $context["helpText"] = ('' === $tmp = ob_get_clean()) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 66
        echo "                            ";
        echo $context["inline"]->getinputWithTags("tags", ($context["title"] ?? null), null, ($context["helpText"] ?? null), null, null, null, "exactTags", ($context["exactTagTitle"] ?? null));
        echo "
                        </form>
                    </div>
                </div>
                <div class=\"XiboData\">
                    <table id=\"displaygroups\" class=\"table table-striped\">
                        <thead>
                            <tr>
                                <th>";
        // line 74
        echo __("ID");
        echo "</th>
                                <th>";
        // line 75
        echo __("Name");
        echo "</th>
                                <th>";
        // line 76
        echo __("Description");
        echo "</th>
                                <th>";
        // line 77
        echo __("Is Dynamic?");
        echo "</th>
                                <th>";
        // line 78
        echo __("Criteria");
        echo "</th>
                                <th>";
        // line 79
        echo __("Criteria Tags");
        echo "</th>
                                <th>";
        // line 80
        echo __("Tags");
        echo "</th>
                                <th>";
        // line 81
        echo __("Row Menu");
        echo "</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
";
    }

    // line 94
    public function block_javaScript($context, array $blocks = [])
    {
        // line 95
        echo "    <script type=\"text/javascript\">
        var table = \$(\"#displaygroups\").DataTable({ \"language\": dataTablesLanguage,
            serverSide: true, stateSave: true, stateDuration: 0,
            stateLoadCallback: function (settings, callback) {
                var data = {};
                \$.ajax({
                    type: \"GET\",
                    async: false,
                    url: \"";
        // line 103
        echo twig_escape_filter($this->env, $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("user.pref"), "html", null, true);
        echo "?preference=displayGroupGrid\",
                    dataType: 'json',
                    success: function (json) {
                        try {
                            if (json.success) {
                                data = JSON.parse(json.data.value);
                            }
                        } catch (e) {
                            // Do nothing
                        }
                    }
                });
                return data;
            },
            stateSaveCallback: function (settings, data) {
                \$.ajax({
                    type: \"POST\",
                    url: \"";
        // line 120
        echo twig_escape_filter($this->env, $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("user.pref"), "html", null, true);
        echo "\",
                    data: {
                        preference: [{
                            option: \"displayGroupGrid\",
                            value: JSON.stringify(data)
                        }]
                    }
                });
            },
            \"filter\": false,
            searchDelay: 3000,
            \"order\": [[ 1, \"asc\"]],
            ajax: {
                \"url\": \"";
        // line 133
        echo twig_escape_filter($this->env, $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("displayGroup.search"), "html", null, true);
        echo "\",
                \"data\": function(d) {
                    \$.extend(d, \$(\"#displaygroups\").closest(\".XiboGrid\").find(\".FilterDiv form\").serializeObject());
                }
            },
            \"columns\": [
                { \"data\": \"displayGroupId\" },
                { \"data\": \"displayGroup\", \"render\": dataTableSpacingPreformatted },
                { \"data\": \"description\" },
                { \"data\": \"isDynamic\", \"render\": dataTableTickCrossColumn },
                { \"data\": \"dynamicCriteria\" },
                { \"data\": \"dynamicCriteriaTags\"},
                {
                    \"name\": \"tags\",
                    \"sortable\": false,
                    \"data\": dataTableCreateTags
                },
                {
                    \"orderable\": false,
                    \"data\": dataTableButtonsColumn
                }
            ]
        });

        table.on('draw', dataTableDraw);
        table.on('draw', { form: \$(\"#displaygroups\").closest(\".XiboGrid\").find(\".FilterDiv form\") }, dataTableCreateTagEvents);
        table.on('processing.dt', dataTableProcessing);
        dataTableAddButtons(table, \$('#displaygroups_wrapper').find('.col-sm-6').eq(1));

        let displayTable;
        let criteria;
        let criteriaTag;
        let useRegexForName;

        function setDeleteMultiSelectFormOpen(dialog) {
            \$(dialog).find('.save-button').prop('disabled', false);

            var \$input = \$('<input type=checkbox id=\"confirmDelete\" name=\"confirmDelete\"> ";
        // line 170
        echo __("Check to confirm deletion");
        echo " </input>');
            \$input.on('change', function() {
                \$(dialog).find('.save-button').prop('disabled', !\$(this).is(':checked'));
            });
            \$(dialog).find('.modal-body').append(\$input);
        }

        function displayGroupAddFormNext() {
            // Get form
            var \$form = \$(\"#displayGroupAddForm\");

            // Set apply and apply reset data
            \$form.data(\"apply\", true);
            \$form.data(\"applyCallback\", 'applyResetCallback');

            // Submit form
            \$form.submit();
        }

        function applyResetCallback(form) {
            // Reset form fields
            \$(form).find('#displayGroup').val(\"\");
        }

        function displayGroupFormOpen(dialog) {
            displayTable = null;

            \$(dialog).find(\"input[name=dynamicCriteria]\").on(\"keyup\", _.debounce(function() {
                displayGroupQueryDynamicMembers(dialog);
            }, 500));

            \$(dialog).find(\"input[name=dynamicCriteriaTags]\").change(function() {
                displayGroupQueryDynamicMembers(dialog);
            });

            const \$form = \$('#displayGroupAddForm');

            // First time in there
            displayGroupQueryDynamicMembers(dialog);
        }

        function displayGroupQueryDynamicMembers(dialog) {

            if (\$(dialog).find(\"input[name=isDynamic]\")[0].checked) {

                criteria = \$(dialog).find(\"input[name=dynamicCriteria]\").val();
                criteriaTag = \$(dialog).find(\"input[name=dynamicCriteriaTags]\").val();
                useRegexForName = \$(dialog).find(\"input[name=useRegexForName]\").val();

                if (criteria === \"\" && criteriaTag === \"\") {
                    if (displayTable != null) {
                        displayTable.destroy();
                        displayTable = null;
                        \$(\"#displayGroupDisplays tbody\").empty();
                    }

                    return;
                }

                if (displayTable != null) {
                    displayTable.ajax.reload();
                } else {
                    displayTable = \$(\"#displayGroupDisplays\").DataTable({
                        \"language\": dataTablesLanguage,
                        serverSide: true,
                        stateSave: true, stateDuration: 0,
                        filter: false,
                        searchDelay: 3000,
                        \"order\": [[1, \"asc\"]],
                        ajax: {
                            \"url\": \"";
        // line 240
        echo twig_escape_filter($this->env, $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("display.search"), "html", null, true);
        echo "\",
                            \"data\": function (d) {
                                //console.log(criteria);
                                //console.log(criteriaTag);
                                \$.extend(d, {display: criteria, tags: criteriaTag, useRegexForName: useRegexForName});
                            }
                        },
                        \"columns\": [
                            {\"data\": \"displayId\"},
                            {\"data\": \"display\"},
                            {\"data\": dataTableCreateTags},
                            {
                                \"data\": \"mediaInventoryStatus\",
                                \"render\": function (data, type, row) {
                                    if (type != \"display\")
                                        return data;

                                    var icon = \"\";
                                    if (data == 1)
                                        icon = \"fa-check\";
                                    else if (data == 0)
                                        icon = \"fa-times\";
                                    else
                                        icon = \"fa-cloud-download\";

                                    return \"<span class='fa \" + icon + \"'></span>\";
                                }
                            },
                            {\"data\": \"licensed\", \"render\": dataTableTickCrossColumn}
                        ]
                    });

                    displayTable.on('processing.dt', dataTableProcessing);
                    displayTable.on('draw', { form: \$(\".displayGroupForm\") }, dataTableCreateTagEvents);
                }
            }
        }

        function displayGroupMembersFormOpen(dialog) {
            
            var control = \$(dialog).find(\".controlDiv\");

            // This contains the changes made since the form open
            if (control.data().members == undefined)
                control.data().members = {
                    displays: {},
                    displayGroups: {}
                };

            var table = \$(\"#displaysMembersTable\").DataTable({ 
                \"language\": dataTablesLanguage,
                serverSide: true, 
                stateSave: true, stateDuration: 0,
                filter: false,
                searchDelay: 3000,
                \"order\": [[1, \"asc\"]],
                ajax: {
                    \"url\": \"";
        // line 297
        echo twig_escape_filter($this->env, $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("display.search"), "html", null, true);
        echo "\",
                    \"data\": function(dataDisplay) {
                        \$.extend(dataDisplay, \$(dialog).find(\"#displayForm\").serializeObject());
                        return dataDisplay;
                    }
                },
                \"columns\": [
                    { \"data\": \"displayId\"},
                    { \"data\": \"display\" },
                    {
                        \"data\": \"mediaInventoryStatus\",
                        \"render\": function (data, type, row) {
                            if (type != \"display\")
                                return data;

                            var icon = \"\";
                            if (data == 1)
                                icon = \"fa-check\";
                            else if (data == 0)
                                icon = \"fa-times\";
                            else
                                icon = \"fa-cloud-download\";

                            return \"<span class='fa \" + icon + \"'></span>\";
                        }
                    },
                    { \"data\": \"loggedIn\", \"render\": dataTableTickCrossColumn},
                    {
                        \"name\": \"clientSort\",
                        \"data\": function (data) {
                            return data.clientType + ' ' + data.clientVersion + '-' + data.clientCode;
                        },
                        \"visible\": false
                    },
                    {
                        \"name\": \"member\",
                        \"data\": function (data, type, row) {
                            if (type != \"display\")
                                return data;

                            var checked = '';
                            
                            // Check if the element is already been checked/unchecked
                            if( typeof control.data().members != \"undefined\" && control.data().members.displays[data.displayId] != undefined){
                                checked = (control.data().members.displays[data.displayId]) ? 'checked' : '';
                            } else {
                                // If its not been altered, check for the original state
                                if( dialog.data().extra ){
                                    dialog.data().extra.displaysAssigned.forEach(function(extraElement) {
                                        if( extraElement.displayId == data.displayId ){
                                            checked = 'checked';
                                        }
                                    });    
                                }
                            }
                            
                            var checkBox = '<input type=\"checkbox\" class=\"checkbox\" data-member-id=' + data.displayId + ' data-member-type=\"display\" ' + checked + '>';
                        
                            // Create checkbox
                            return checkBox;
                        }
                    },
                ]
            });

            table.on('draw', dataTableDraw);
            table.on('processing.dt', dataTableProcessing);
            
            var tableGroup = \$(\"#displaysGroupsMembersTable\").DataTable({ 
                \"language\": dataTablesLanguage,
                serverSide: true, stateSave: true, stateDuration: 0,
                filter: false,
                searchDelay: 3000,
                \"order\": [[1, \"asc\"]],
                ajax: {
                    \"url\": \"";
        // line 372
        echo twig_escape_filter($this->env, $this->env->getExtension('Slim\Views\TwigExtension')->urlFor("displayGroup.search"), "html", null, true);
        echo "\",
                    \"data\": function(dataGroup) {
                        \$.extend(dataGroup, \$(\"#displaysGroupsMembersTable\").closest(\".XiboGrid\").find(\".FilterDiv form\").serializeObject());
                        return dataGroup;
                    }
                },
                \"columns\": [
                    { \"data\": \"displayGroupId\"},
                    { \"data\": \"displayGroup\"},
                    {
                        \"name\": \"member\",
                        \"data\": function (data, type, row) {
                            if (type != \"display\")
                                return data;

                            var checked = '';
                            
                            // Check if the element is already been checked/unchecked
                            if( typeof control.data().members != \"undefined\" && control.data().members.displayGroups[data.displayGroupId] != undefined){
                                checked = (control.data().members.displayGroups[data.displayGroupId]) ? 'checked' : '';
                            } else {
                                // If its not been altered, check for the original state
                                if( dialog.data().extra ){
                                    dialog.data().extra.displayGroupsAssigned.forEach(function(extraElement) {
                                        if( extraElement.displayGroupId == data.displayGroupId ){
                                            checked = 'checked';
                                        }
                                    });    
                                }
                            }
                            
                            var checkBox = '<input type=\"checkbox\" class=\"checkbox\" data-member-id=' + data.displayGroupId + ' data-member-type=\"displayGroup\" ' + checked + '>';
                        
                            // Create checkbox
                            return checkBox;
                        }
                    },
                ]
            });
            
            tableGroup.on('draw', dataTableDraw);
            tableGroup.on('processing.dt', dataTableProcessing);
                
            // Bind to the checkboxes change event
            control.on(\"change\", \".checkbox\", function() {
                
                // Update our global members data with this
                var memberId = \$(this).data().memberId;
                var memberType = \$(this).data().memberType;
                var value = \$(this).is(\":checked\");

                if (memberType == \"display\")
                    control.data().members.displays[memberId] = (value) ? 1 : 0;
                else if (memberType == \"displayGroup\")
                    control.data().members.displayGroups[memberId] = (value) ? 1 : 0;
            });
        }

        function displayGroupMembersFormSubmit(id) {

            var form = \$(\"#\" + id);
            var members = form.data().members;

            // There may not have been any changes
            if (members == undefined) {
                // No changes
                XiboDialogClose();
                return;
            }

            // Create a new queue.
            window.queue = \$.jqmq({

                // Next item will be processed only when queue.next() is called in callback.
                delay: -1,

                // Process queue items one-at-a-time.
                batch: 1,

                // For each queue item, execute this function, making an AJAX request. Only
                // continue processing the queue once the AJAX request's callback executes.
                callback: function( data ) {

                    // Make an AJAX call
                    \$.ajax({
                        type: \"POST\",
                        url: data.url,
                        cache: false,
                        dataType: \"json\",
                        data: \$.param(data.data),
                        success: function(response, textStatus, error) {

                            if (response.success) {

                                // Success - what do we do now?
                                if (response.message != '')
                                    SystemMessage(response.message, true);

                                // Process the next item
                                queue.next();
                            }
                            else {
                                // Why did we fail?
                                if (response.login) {
                                    // We were logged out
                                    LoginBox(response.message);
                                }
                                else {
                                    // Likely just an error that we want to report on
                                    form.find(\".saving\").remove();
                                    SystemMessageInline(response.message, form.closest(\".modal\"));
                                }
                            }
                        },
                        error: function(responseText) {
                            SystemMessage(responseText, false);
                        }
                    });
                },
                // When the queue completes naturally, execute this function.
                complete: function() {
                    // Remove the save button
                    form.find(\".saving\").parent().remove();

                    // Refresh the grids
                    // (this is a global refresh)
                    XiboRefreshAllGrids();

                    // Close the dialog
                    XiboDialogClose();
                }
            });

            var addedToQueue = false;

            // Build an array of id's to assign and an array to unassign
            var assign = [];
            var unassign = [];

            \$.each(members.displays, function(name, value) {
                if (value == 1)
                    assign.push(name);
                else
                    unassign.push(name);
            });

            if (assign.length > 0 || unassign.length > 0) {

                var data = {
                    data: {},
                    url: form.data().url
                };
                data.data[form.data().param] = assign;
                data.data[form.data().paramUnassign] = unassign;

                // Queue
                queue.add(data);

                addedToQueue = true;
            }

            // Build an array of id's to assign and an array to unassign
            var assignGroup = [];
            var unassignGroup = [];

            \$.each(members.displayGroups, function(name, value) {
                if (value == 1)
                    assignGroup.push(name);
                else
                    unassignGroup.push(name);
            });

            if (assignGroup.length > 0 || unassignGroup.length > 0) {
                var dataGroup = {
                    data: {},
                    url: form.data().groupsUrl
                };
                dataGroup.data[form.data().groupsParam] = assignGroup;
                dataGroup.data[form.data().groupsParamUnassign] = unassignGroup;

                // Queue
                queue.add(dataGroup);

                addedToQueue = true;
            }

            if (!addedToQueue) {
                XiboDialogClose();
            } else {
                // Start the queue
                queue.start();
            }
        }
    </script>
";
    }

    public function getTemplateName()
    {
        return "displaygroup-page.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  520 => 372,  442 => 297,  382 => 240,  309 => 170,  269 => 133,  253 => 120,  233 => 103,  223 => 95,  220 => 94,  204 => 81,  200 => 80,  196 => 79,  192 => 78,  188 => 77,  184 => 76,  180 => 75,  176 => 74,  164 => 66,  159 => 65,  154 => 64,  150 => 63,  144 => 61,  140 => 60,  134 => 58,  129 => 57,  125 => 56,  119 => 54,  114 => 53,  111 => 42,  107 => 41,  98 => 35,  90 => 30,  83 => 27,  79 => 26,  72 => 22,  67 => 20,  64 => 19,  61 => 18,  50 => 14,  47 => 13,  44 => 12,  39 => 9,  37 => 10,  31 => 9,);
    }

    /** @deprecated since 1.27 (to be removed in 2.0). Use getSourceContext() instead */
    public function getSource()
    {
        @trigger_error('The '.__METHOD__.' method is deprecated since version 1.27 and will be removed in 2.0. Use getSourceContext() instead.', E_USER_DEPRECATED);

        return $this->getSourceContext()->getCode();
    }

    public function getSourceContext()
    {
        return new Source("{#
/*
 * Spring Signage Ltd - http://www.springsignage.com
 * Copyright (C) 2015 Spring Signage Ltd
 * (\${FILE_NAME})
 */

#}
{% extends \"authed.twig\" %}
{% import \"inline.twig\" as inline %}

{% block actionMenu %}
    <ul class=\"nav nav-pills pull-right\">
        <li class=\"btn btn-success btn-xs\"><a class=\"XiboFormButton btns\" title=\"{% trans \"Add a new Display Group\" %}\" href=\"{{ urlFor(\"displayGroup.add.form\") }}\"> <i class=\"fa fa-desktop\" aria-hidden=\"true\"></i> {% trans \"Add Display Group\" %}</a></li>
    </ul>
{% endblock %}

{% block pageContent %}
    <div class=\"widget\">
        <div class=\"widget-title\">{% trans \"Display Groups\" %}</div>
        <div class=\"widget-body\">
            <div class=\"XiboGrid\" id=\"{{ random() }}\">
                <div class=\"XiboFilter well\">
                    <div class=\"FilterDiv\" id=\"Filter\">
                        <form class=\"form-inline\">
                            {% set title %}{% trans \"ID\" %}{% endset %}
                            {{ inline.input(\"displayGroupId\", title) }}

                            <div class=\"form-group \">
                                <label class=\"control-label\" title=\"\" for=\"displayGroup\" accesskey=\"\">{% trans \"Name\" %}</label>
                                <div>
                                    <div class=\"input-group\">
                                        <input class=\"form-control\" name=\"displayGroup\" type=\"text\" id=\"displayGroup\" value=\"\">
                                        <span class=\"input-group-addon\">
                                            <input title=\"{% trans \"Use Regex?\" %}\" type=\"checkbox\" id=\"useRegexForName\" name=\"useRegexForName\">
                                        </span>
                                    </div>
                                </div>
                            </div>

                            {% set title %}{% trans \"Display\" %}{% endset %}
                            {% set attributes = [
                                { name: \"data-width\", value: \"200px\" },
                                { name: \"data-allow-clear\", value: \"true\" },
                                { name: \"data-placeholder--id\", value: null },
                                { name: \"data-placeholder--value\", value: \"\" },
                                { name: \"data-search-url\", value: urlFor(\"display.search\") },
                                { name: \"data-search-term\", value: \"display\" },
                                { name: \"data-search-term-tags\", value: \"tags\" },
                                { name: \"data-id-property\", value: \"displayId\" },
                                { name: \"data-text-property\", value: \"display\" }
                            ] %}
                            {% set helpText %}{% trans \"Return Display Groups that directly contain the selected Display.\" %}{% endset %}
                            {{ inline.dropdown(\"displayId\", \"single\", title, \"\", null, \"displayId\", \"display\", helpText, \"pagedSelect\", \"\", \"\", \"\", attributes) }}

                            {% set title %}{% trans \"Nested Display\" %}{% endset %}
                            {% set helpText %}{% trans \"Return Display Groups that contain the selected Display somewhere in the nested Display Group relationship tree.\" %}{% endset %}
                            {{ inline.dropdown(\"nestedDisplayId\", \"single\", title, \"\", null, \"displayId\", \"display\", helpText, \"pagedSelect\", \"\", \"\", \"\", attributes) }}

                            {% set title %}{% trans \"Dynamic Criteria\" %}{% endset %}
                            {{ inline.input(\"dynamicCriteria\", title) }}

                            {% set title %}{% trans \"Tags\" %}{% endset %}
                            {% set exactTagTitle %}{% trans \"Exact match?\" %}{% endset %}
                            {% set helpText %}{% trans \"A comma separated list of tags to filter by. Enter a Tag value preceded with | to filter by Tag values. Enter --no-tag to see items without tags.\" %}{% endset %}
                            {{ inline.inputWithTags(\"tags\", title, null, helpText, null, null, null, \"exactTags\", exactTagTitle) }}
                        </form>
                    </div>
                </div>
                <div class=\"XiboData\">
                    <table id=\"displaygroups\" class=\"table table-striped\">
                        <thead>
                            <tr>
                                <th>{% trans \"ID\" %}</th>
                                <th>{% trans \"Name\" %}</th>
                                <th>{% trans \"Description\" %}</th>
                                <th>{% trans \"Is Dynamic?\" %}</th>
                                <th>{% trans \"Criteria\" %}</th>
                                <th>{% trans \"Criteria Tags\" %}</th>
                                <th>{% trans \"Tags\" %}</th>
                                <th>{% trans \"Row Menu\" %}</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
{% endblock %}

{% block javaScript %}
    <script type=\"text/javascript\">
        var table = \$(\"#displaygroups\").DataTable({ \"language\": dataTablesLanguage,
            serverSide: true, stateSave: true, stateDuration: 0,
            stateLoadCallback: function (settings, callback) {
                var data = {};
                \$.ajax({
                    type: \"GET\",
                    async: false,
                    url: \"{{ urlFor(\"user.pref\") }}?preference=displayGroupGrid\",
                    dataType: 'json',
                    success: function (json) {
                        try {
                            if (json.success) {
                                data = JSON.parse(json.data.value);
                            }
                        } catch (e) {
                            // Do nothing
                        }
                    }
                });
                return data;
            },
            stateSaveCallback: function (settings, data) {
                \$.ajax({
                    type: \"POST\",
                    url: \"{{ urlFor(\"user.pref\") }}\",
                    data: {
                        preference: [{
                            option: \"displayGroupGrid\",
                            value: JSON.stringify(data)
                        }]
                    }
                });
            },
            \"filter\": false,
            searchDelay: 3000,
            \"order\": [[ 1, \"asc\"]],
            ajax: {
                \"url\": \"{{ urlFor(\"displayGroup.search\") }}\",
                \"data\": function(d) {
                    \$.extend(d, \$(\"#displaygroups\").closest(\".XiboGrid\").find(\".FilterDiv form\").serializeObject());
                }
            },
            \"columns\": [
                { \"data\": \"displayGroupId\" },
                { \"data\": \"displayGroup\", \"render\": dataTableSpacingPreformatted },
                { \"data\": \"description\" },
                { \"data\": \"isDynamic\", \"render\": dataTableTickCrossColumn },
                { \"data\": \"dynamicCriteria\" },
                { \"data\": \"dynamicCriteriaTags\"},
                {
                    \"name\": \"tags\",
                    \"sortable\": false,
                    \"data\": dataTableCreateTags
                },
                {
                    \"orderable\": false,
                    \"data\": dataTableButtonsColumn
                }
            ]
        });

        table.on('draw', dataTableDraw);
        table.on('draw', { form: \$(\"#displaygroups\").closest(\".XiboGrid\").find(\".FilterDiv form\") }, dataTableCreateTagEvents);
        table.on('processing.dt', dataTableProcessing);
        dataTableAddButtons(table, \$('#displaygroups_wrapper').find('.col-sm-6').eq(1));

        let displayTable;
        let criteria;
        let criteriaTag;
        let useRegexForName;

        function setDeleteMultiSelectFormOpen(dialog) {
            \$(dialog).find('.save-button').prop('disabled', false);

            var \$input = \$('<input type=checkbox id=\"confirmDelete\" name=\"confirmDelete\"> {% trans %} Check to confirm deletion {% endtrans %} </input>');
            \$input.on('change', function() {
                \$(dialog).find('.save-button').prop('disabled', !\$(this).is(':checked'));
            });
            \$(dialog).find('.modal-body').append(\$input);
        }

        function displayGroupAddFormNext() {
            // Get form
            var \$form = \$(\"#displayGroupAddForm\");

            // Set apply and apply reset data
            \$form.data(\"apply\", true);
            \$form.data(\"applyCallback\", 'applyResetCallback');

            // Submit form
            \$form.submit();
        }

        function applyResetCallback(form) {
            // Reset form fields
            \$(form).find('#displayGroup').val(\"\");
        }

        function displayGroupFormOpen(dialog) {
            displayTable = null;

            \$(dialog).find(\"input[name=dynamicCriteria]\").on(\"keyup\", _.debounce(function() {
                displayGroupQueryDynamicMembers(dialog);
            }, 500));

            \$(dialog).find(\"input[name=dynamicCriteriaTags]\").change(function() {
                displayGroupQueryDynamicMembers(dialog);
            });

            const \$form = \$('#displayGroupAddForm');

            // First time in there
            displayGroupQueryDynamicMembers(dialog);
        }

        function displayGroupQueryDynamicMembers(dialog) {

            if (\$(dialog).find(\"input[name=isDynamic]\")[0].checked) {

                criteria = \$(dialog).find(\"input[name=dynamicCriteria]\").val();
                criteriaTag = \$(dialog).find(\"input[name=dynamicCriteriaTags]\").val();
                useRegexForName = \$(dialog).find(\"input[name=useRegexForName]\").val();

                if (criteria === \"\" && criteriaTag === \"\") {
                    if (displayTable != null) {
                        displayTable.destroy();
                        displayTable = null;
                        \$(\"#displayGroupDisplays tbody\").empty();
                    }

                    return;
                }

                if (displayTable != null) {
                    displayTable.ajax.reload();
                } else {
                    displayTable = \$(\"#displayGroupDisplays\").DataTable({
                        \"language\": dataTablesLanguage,
                        serverSide: true,
                        stateSave: true, stateDuration: 0,
                        filter: false,
                        searchDelay: 3000,
                        \"order\": [[1, \"asc\"]],
                        ajax: {
                            \"url\": \"{{ urlFor(\"display.search\") }}\",
                            \"data\": function (d) {
                                //console.log(criteria);
                                //console.log(criteriaTag);
                                \$.extend(d, {display: criteria, tags: criteriaTag, useRegexForName: useRegexForName});
                            }
                        },
                        \"columns\": [
                            {\"data\": \"displayId\"},
                            {\"data\": \"display\"},
                            {\"data\": dataTableCreateTags},
                            {
                                \"data\": \"mediaInventoryStatus\",
                                \"render\": function (data, type, row) {
                                    if (type != \"display\")
                                        return data;

                                    var icon = \"\";
                                    if (data == 1)
                                        icon = \"fa-check\";
                                    else if (data == 0)
                                        icon = \"fa-times\";
                                    else
                                        icon = \"fa-cloud-download\";

                                    return \"<span class='fa \" + icon + \"'></span>\";
                                }
                            },
                            {\"data\": \"licensed\", \"render\": dataTableTickCrossColumn}
                        ]
                    });

                    displayTable.on('processing.dt', dataTableProcessing);
                    displayTable.on('draw', { form: \$(\".displayGroupForm\") }, dataTableCreateTagEvents);
                }
            }
        }

        function displayGroupMembersFormOpen(dialog) {
            
            var control = \$(dialog).find(\".controlDiv\");

            // This contains the changes made since the form open
            if (control.data().members == undefined)
                control.data().members = {
                    displays: {},
                    displayGroups: {}
                };

            var table = \$(\"#displaysMembersTable\").DataTable({ 
                \"language\": dataTablesLanguage,
                serverSide: true, 
                stateSave: true, stateDuration: 0,
                filter: false,
                searchDelay: 3000,
                \"order\": [[1, \"asc\"]],
                ajax: {
                    \"url\": \"{{ urlFor(\"display.search\") }}\",
                    \"data\": function(dataDisplay) {
                        \$.extend(dataDisplay, \$(dialog).find(\"#displayForm\").serializeObject());
                        return dataDisplay;
                    }
                },
                \"columns\": [
                    { \"data\": \"displayId\"},
                    { \"data\": \"display\" },
                    {
                        \"data\": \"mediaInventoryStatus\",
                        \"render\": function (data, type, row) {
                            if (type != \"display\")
                                return data;

                            var icon = \"\";
                            if (data == 1)
                                icon = \"fa-check\";
                            else if (data == 0)
                                icon = \"fa-times\";
                            else
                                icon = \"fa-cloud-download\";

                            return \"<span class='fa \" + icon + \"'></span>\";
                        }
                    },
                    { \"data\": \"loggedIn\", \"render\": dataTableTickCrossColumn},
                    {
                        \"name\": \"clientSort\",
                        \"data\": function (data) {
                            return data.clientType + ' ' + data.clientVersion + '-' + data.clientCode;
                        },
                        \"visible\": false
                    },
                    {
                        \"name\": \"member\",
                        \"data\": function (data, type, row) {
                            if (type != \"display\")
                                return data;

                            var checked = '';
                            
                            // Check if the element is already been checked/unchecked
                            if( typeof control.data().members != \"undefined\" && control.data().members.displays[data.displayId] != undefined){
                                checked = (control.data().members.displays[data.displayId]) ? 'checked' : '';
                            } else {
                                // If its not been altered, check for the original state
                                if( dialog.data().extra ){
                                    dialog.data().extra.displaysAssigned.forEach(function(extraElement) {
                                        if( extraElement.displayId == data.displayId ){
                                            checked = 'checked';
                                        }
                                    });    
                                }
                            }
                            
                            var checkBox = '<input type=\"checkbox\" class=\"checkbox\" data-member-id=' + data.displayId + ' data-member-type=\"display\" ' + checked + '>';
                        
                            // Create checkbox
                            return checkBox;
                        }
                    },
                ]
            });

            table.on('draw', dataTableDraw);
            table.on('processing.dt', dataTableProcessing);
            
            var tableGroup = \$(\"#displaysGroupsMembersTable\").DataTable({ 
                \"language\": dataTablesLanguage,
                serverSide: true, stateSave: true, stateDuration: 0,
                filter: false,
                searchDelay: 3000,
                \"order\": [[1, \"asc\"]],
                ajax: {
                    \"url\": \"{{ urlFor(\"displayGroup.search\") }}\",
                    \"data\": function(dataGroup) {
                        \$.extend(dataGroup, \$(\"#displaysGroupsMembersTable\").closest(\".XiboGrid\").find(\".FilterDiv form\").serializeObject());
                        return dataGroup;
                    }
                },
                \"columns\": [
                    { \"data\": \"displayGroupId\"},
                    { \"data\": \"displayGroup\"},
                    {
                        \"name\": \"member\",
                        \"data\": function (data, type, row) {
                            if (type != \"display\")
                                return data;

                            var checked = '';
                            
                            // Check if the element is already been checked/unchecked
                            if( typeof control.data().members != \"undefined\" && control.data().members.displayGroups[data.displayGroupId] != undefined){
                                checked = (control.data().members.displayGroups[data.displayGroupId]) ? 'checked' : '';
                            } else {
                                // If its not been altered, check for the original state
                                if( dialog.data().extra ){
                                    dialog.data().extra.displayGroupsAssigned.forEach(function(extraElement) {
                                        if( extraElement.displayGroupId == data.displayGroupId ){
                                            checked = 'checked';
                                        }
                                    });    
                                }
                            }
                            
                            var checkBox = '<input type=\"checkbox\" class=\"checkbox\" data-member-id=' + data.displayGroupId + ' data-member-type=\"displayGroup\" ' + checked + '>';
                        
                            // Create checkbox
                            return checkBox;
                        }
                    },
                ]
            });
            
            tableGroup.on('draw', dataTableDraw);
            tableGroup.on('processing.dt', dataTableProcessing);
                
            // Bind to the checkboxes change event
            control.on(\"change\", \".checkbox\", function() {
                
                // Update our global members data with this
                var memberId = \$(this).data().memberId;
                var memberType = \$(this).data().memberType;
                var value = \$(this).is(\":checked\");

                if (memberType == \"display\")
                    control.data().members.displays[memberId] = (value) ? 1 : 0;
                else if (memberType == \"displayGroup\")
                    control.data().members.displayGroups[memberId] = (value) ? 1 : 0;
            });
        }

        function displayGroupMembersFormSubmit(id) {

            var form = \$(\"#\" + id);
            var members = form.data().members;

            // There may not have been any changes
            if (members == undefined) {
                // No changes
                XiboDialogClose();
                return;
            }

            // Create a new queue.
            window.queue = \$.jqmq({

                // Next item will be processed only when queue.next() is called in callback.
                delay: -1,

                // Process queue items one-at-a-time.
                batch: 1,

                // For each queue item, execute this function, making an AJAX request. Only
                // continue processing the queue once the AJAX request's callback executes.
                callback: function( data ) {

                    // Make an AJAX call
                    \$.ajax({
                        type: \"POST\",
                        url: data.url,
                        cache: false,
                        dataType: \"json\",
                        data: \$.param(data.data),
                        success: function(response, textStatus, error) {

                            if (response.success) {

                                // Success - what do we do now?
                                if (response.message != '')
                                    SystemMessage(response.message, true);

                                // Process the next item
                                queue.next();
                            }
                            else {
                                // Why did we fail?
                                if (response.login) {
                                    // We were logged out
                                    LoginBox(response.message);
                                }
                                else {
                                    // Likely just an error that we want to report on
                                    form.find(\".saving\").remove();
                                    SystemMessageInline(response.message, form.closest(\".modal\"));
                                }
                            }
                        },
                        error: function(responseText) {
                            SystemMessage(responseText, false);
                        }
                    });
                },
                // When the queue completes naturally, execute this function.
                complete: function() {
                    // Remove the save button
                    form.find(\".saving\").parent().remove();

                    // Refresh the grids
                    // (this is a global refresh)
                    XiboRefreshAllGrids();

                    // Close the dialog
                    XiboDialogClose();
                }
            });

            var addedToQueue = false;

            // Build an array of id's to assign and an array to unassign
            var assign = [];
            var unassign = [];

            \$.each(members.displays, function(name, value) {
                if (value == 1)
                    assign.push(name);
                else
                    unassign.push(name);
            });

            if (assign.length > 0 || unassign.length > 0) {

                var data = {
                    data: {},
                    url: form.data().url
                };
                data.data[form.data().param] = assign;
                data.data[form.data().paramUnassign] = unassign;

                // Queue
                queue.add(data);

                addedToQueue = true;
            }

            // Build an array of id's to assign and an array to unassign
            var assignGroup = [];
            var unassignGroup = [];

            \$.each(members.displayGroups, function(name, value) {
                if (value == 1)
                    assignGroup.push(name);
                else
                    unassignGroup.push(name);
            });

            if (assignGroup.length > 0 || unassignGroup.length > 0) {
                var dataGroup = {
                    data: {},
                    url: form.data().groupsUrl
                };
                dataGroup.data[form.data().groupsParam] = assignGroup;
                dataGroup.data[form.data().groupsParamUnassign] = unassignGroup;

                // Queue
                queue.add(dataGroup);

                addedToQueue = true;
            }

            if (!addedToQueue) {
                XiboDialogClose();
            } else {
                // Start the queue
                queue.start();
            }
        }
    </script>
{% endblock %}", "displaygroup-page.twig", "/home/dlccorporativo/signage.dlccorporativo.com/xib/views/displaygroup-page.twig");
    }
}
